!Object constantsFor: 'Geos Libraries'!

geosLIB53 'SYSTEM\pccom'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

PCComInit: port with: baud with: timeout with: callbackOptr with: flags
	"PCComReturnType pascal PCComInit(SerialPortNum port, SerialBaud baud, word timeout, optr callbackOptr, PCComInitFlags flags) in pccom.goh"
	^GEOS call: port with: baud with: timeout with: callbackOptr with: flags with: #[53 0 0 1 1 1 2 1 1]!

PCComExit
	"PCComReturnType pascal PCComExit(void) in pccom.goh"
	^GEOS call: #[53 0 1 1]!

PCComAbort
	"void pascal PCComAbort(void) in pccom.goh"
	^GEOS call: #[53 0 2 0]!

PCComReset
	"PCComReturnType pascal PCComReset(void) in pccom.goh"
	^GEOS call: #[53 0 17 1]!

PCComGet: dataBlock with: bytesPerStatus with: statusDest with: statusMSG with: destPathname
	"PCComFullReturnType pascal PCComGet(hptr dataBlock, word bytesPerStatus, optr statusDest, word statusMSG, char *destPathname) in pccom.goh"
	^GEOS call: dataBlock with: bytesPerStatus with: statusDest with: statusMSG with: destPathname with: #[53 0 4 1 1 2 1 3 1]!

PCComSend: sourcePathname with: bytesPerStatus with: statusOptr with: statusMSG with: destPathname
	"PCComFullReturnType pascal PCComSend(char *sourcePathname, word bytesPerStatus, optr statusOptr, word statusMSG, char *destPathname) in pccom.goh"
	^GEOS call: sourcePathname with: bytesPerStatus with: statusOptr with: statusMSG with: destPathname with: #[53 0 5 3 1 2 1 3 1]!

PCComStatus: statusBuffer with: currentFilename
	"PCComFullReturnType pascal PCComStatus(struct StatusReply *statusBuffer, char *currentFilename) in pccom.goh"
	^GEOS call: statusBuffer with: currentFilename with: #[53 0 6 3 3 1]!

PCComPWD: buffer
	"PCComFullReturnType pascal PCComPWD(char *buffer) in pccom.goh"
	^GEOS call: buffer with: #[53 0 14 3 1]!

PCComCD: dirPathname
	"PCComFullReturnType pascal PCComCD(const char *dirPathname) in pccom.goh"
	^GEOS call: dirPathname with: #[53 0 7 3 1]!

PCComMkdir: dirPathname
	"PCComFullReturnType pascal PCComMkdir(char *dirPathname) in pccom.goh"
	^GEOS call: dirPathname with: #[53 0 8 3 1]!

PCComListDrives: dataBlock
	"PCComFullReturnType pascal PCComListDrives(hptr dataBlock) in pccom.goh"
	^GEOS call: dataBlock with: #[53 0 11 1 1]!

PCComGetFreeSpace: driveSpace with: driveLetter
	"PCComFullReturnType pascal PCComGetFreeSpace(dword *driveSpace, word driveLetter) in pccom.goh"
	^GEOS call: driveSpace with: driveLetter with: #[53 0 15 3 1 1]!

PCComRemark: remark
	"PCComFullReturnType pascal PCComRemark(char *remark) in pccom.goh"
	^GEOS call: remark with: #[53 0 13 3 1]!

PCComGetFileSize: fileSize with: filename
	"PCComFullReturnType pascal PCComGetFileSize(dword *fileSize, char *filename) in pccom.goh"
	^GEOS call: fileSize with: filename with: #[53 0 9 3 3 1]!

PCComDir: dataBlock with: detailLevel with: fileSpec
	"PCComFullReturnType pascal PCComDir(hptr dataBlock, PCComDirDetailLevel detailLevel, char *fileSpec) in pccom.goh"
	^GEOS call: dataBlock with: detailLevel with: fileSpec with: #[53 0 10 1 1 3 1]!

PCComFileEnum: params with: bufCreated with: numNoFit
	"word pascal PCComFileEnum(FileEnumParams *params, MemHandle *bufCreated, word *numNoFit) in pccom.goh"
	^GEOS call: params with: bufCreated with: numNoFit with: #[53 0 12 3 3 3 1]!

!

GenFileSelector subclass: #PCComFileSelector
	instanceVariableNames: ''
	classVariableNames: ''!

!PCComFileSelector comment!
Library pccom, file pccom.goh! !

!PCComFileSelector class methodsFor: 'library linkage'!

library
	^53!

entry
	^16!
!

!PCComFileSelector methodsFor: 'Geos instance variables'!

pcfsiCurrentRemotePath
	"@instance PathName PCFSI_currentRemotePath"
	"#array #int8[((((32+5*(32 / sizeof(TCHAR)+1)) + 1)+1) & 0xfffe) * sizeof(TCHAR)] [64, 198]"
	^self!

pcfsiDriveListing
	"@instance hptr PCFSI_driveListing"
	^self wordAt: 262!

pcfsiDriveListing: value
	"@instance hptr PCFSI_driveListing"
	^self wordAt: 262 put: value!

pcfsiCurrentVolume
	"@instance FileLongName PCFSI_currentVolume"
	"#array #int8[36] [264, 36]"
	^self!

!

!PCComFileSelector methodsFor: 'Geos vardata'!

!

!PCComFileSelector methodsFor: 'Geos messages'!

!

